﻿using UnityEngine;
using System.Collections;

public class Missile : MonoBehaviour
{
    public float launchDate;
    public AudioSource source1;
    public GameObject boom;
    public ParticleSystem traineeTorpille;
    public AudioClip torpedoBoomSFX;

    bool boomed = false;
    
    // Use this for initialization
    void Start ()
    {
        launchDate = Time.time;
        boom.SetActive(false);
        traineeTorpille.Play();

    }

    // Update is called once per frame
    void Update()
    {
        if (!boomed)
        {
            transform.Translate(Vector3.forward * Time.deltaTime * 300.0f);
        }
               

        if (Time.time - launchDate > 2.0f && !boomed)
        {
       
            StartCoroutine("explosion");
            boomed = true;
        }

        
        
    }
    void OnTriggerEnter(Collider collision)
    {

        Debug.Log("I touch " + collision.gameObject.name);

        Mines mine = collision.gameObject.GetComponent<Mines>();
        MoveSubmarine submarine = collision.gameObject.GetComponent<MoveSubmarine>();
        EnemyMissile torpilleennemie = collision.gameObject.GetComponent<EnemyMissile>();
        Missile torpille = collision.gameObject.GetComponent<Missile>();
        Healthennemy enemysubmarine = collision.gameObject.GetComponent<Healthennemy>();
        HealthBB bigBoss = collision.gameObject.GetComponent<HealthBB>();
        Plateform plateform = collision.gameObject.GetComponent<Plateform>();

        if (submarine==null && mine==null && enemysubmarine==null && plateform==null && bigBoss==null)
        {
            // For all others : kill!
            Destroy(collision.gameObject);

            // Destruct myself
            //Destroy(gameObject);

            StartCoroutine("explosion");
            boomed = true;
        }

        if (enemysubmarine != null)
        {
           
            enemysubmarine.GetComponent<Healthennemy>().HealthManage();
            // Destruct myself
            //Destroy(gameObject);

            StartCoroutine("explosion");
            boomed = true;
        }

        if (bigBoss != null)
        {

            bigBoss.GetComponent<HealthBB>().HealthManage();
            // Destruct myself
            //Destroy(gameObject);

            StartCoroutine("explosion");
            boomed = true;
        }

        if (plateform!= null)
        {
            StartCoroutine("explosion");
            boomed = true;
        }


        if (torpilleennemie==null && torpille==null && submarine==null && mine==null)
        {
            Score.score += 100;
        }

        


        if (mine != null)
        {
            Score.score += 50;
            boomed = true;
            StartCoroutine("explosion");
        }

    }

    public IEnumerator explosion()
    {
        traineeTorpille.Stop();
        boom.SetActive(true);
        GetComponent<Renderer>().enabled = false;
        source1.clip = torpedoBoomSFX;
        source1.Play();
        yield return new WaitForSeconds(1.0f);
        Destroy(gameObject);
    }

}

